@extends('layout')
@section('content')
@include('partials.breadcrumb')




<!-- blog post begin-->
<div class="blog-post">
    <div class="container">

        <div class="row">
            <div class="col-xl-8 col-lg-8">
                <div class="row">
                    @foreach($posts as $data)
                    <div class="col-xl-6 col-lg-6 col-md-6">
                        <div class="single-blog">
                            <div class="part-img">
                                <img src="{{asset('assets/images/post/'.$data->thumb)}}" alt="{{__($data->title)}}">
                            </div>
                            <div class="part-text">
                                <h3><a href="{{route('blog.details',[$data->id, str_slug($data->title)])}}">{{__($data->title)}}</a></h3>
                                <p>{{str_limit(strip_tags($data->details),100)}}</p>
                                <a class="read-more mt-2" href="{{route('blog.details',[$data->id, str_slug($data->title)])}}"><span><i class="fas fa-book-reader"></i></span> Read More</a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <div class="col-xl-4 col-lg-4 col-md-12">
                <div class="sidebar">
                    <div class="row">
                        @include('partials.category')
                        @include('partials.popular-post')
                    </div>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12">
                {{$posts->links()}}
            </div>


        </div>




    </div>
</div>
<!-- blog post end -->



@stop